 ; Floodlight drawing program.
 ; Copyright 2000, 2010 by Rocket Software Ltd.
 ; Could civilization justify its existence without electric lights?
 (DEFUN C:FLOOD (/ dimsc pa ang zerf bellp bells totang pc vertx1)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimsc (misps))
  (setq pa (getpoint "\nCentre: "))
  (setq ang (getangle pa "\nAngle: "))
  (setq bellp (getint "\nNumber of lights <3>: "))
  (if bellp (setq bells bellp) (setq bells 3))
  (setq totang (* (/ pi 2) (1- bells)))
  (if (/= bells 4) (setq ang (- ang (/ totang 2))))
  (if (= bells 1) (setq zerf t))
  (if (> bells 4)
      (progn
           (prompt (strcat "\nYou can't have " (itoa bells) " bells -"
                           " I will make four."))
           (setq bells 4)))
  (command "pline")
  (while (> bells 0)
         (setq bells (1- bells))
         (command (setq pc (polar pa ang (* 2 dimsc))))
         (if (null vertx1) (setq vertx1 pc))
         (command (polar (polar pa ang (* 8 dimsc))
                         (+ ang (/ pi 2)) (* dimsc 3)))
         (command (polar (polar pa ang (* 8 dimsc))
                         (- ang (/ pi 2)) (* dimsc 3)))
         (command pc)
         (setq ang (+ ang (/ pi 2)))
         (if (> bells 0)
             (command "a" "ce" pa (polar pa ang (* 2 dimsc)) "l")))
  (if zerf
      (command "a" "ce" pa "a" 180 pc "")
      (command "a" "ce" pa vertx1 "l" ""))
 (princ))